<?php


namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'email'      => ['required', 'string', Rule::unique("users", "email")->ignore($this->id), 'email', 'max:100'],
            //'phone' => 'required|string|max:20|unique:users,phone',
            'phone'=>['required', 'string', Rule::unique("users", "phone")->ignore($this->id), 'max:100']
        ];
    }
}
