<?php $__env->startSection('main-content'); ?>
<section class="section">
    <div class="section-header">
        <h1><?php echo e(__('dashboard.dashboard')); ?></h1>
        <?php echo e(Breadcrumbs::render('dashboard')); ?>

    </div>
    <div class="row">
        <div class="col-md-12">
            <?php if(!blank($attendance)): ?>
            <div class="float-right  d-flex text-center" style="margin-left:auto">
                <p class="mr-2">
                    <span class="clock-span"><i class="fas fa-4x fa-clock"></i> <?php echo e(date('g:i A')); ?></span><br>
                    <?php if($attendance->checkin_time): ?>
                    <span class="text-success">
                        <?php echo e(__('dashboard.clock_in_at')); ?> - <?php echo e($attendance->checkin_time); ?>

                        <?php if($attendance->checkout_time): ?> <span class="text-danger ml-2">
                            <?php echo e(__('dashboard.clock_out_at')); ?> - <?php echo e($attendance->checkout_time); ?></span><?php endif; ?>
                    </span>
                    <?php endif; ?>
                </p>
                <?php if(!$attendance->checkout_time): ?>
                <form action="<?php echo e(route('admin.attendance.clockout')); ?>" method="post">
                    <?php echo e(csrf_field()); ?>

                    <button class="btn  d-flex inputbtnclockout align-items-center btn-dark" type="submit"><i
                            class="fas fa-4x fa-sign-out-alt"></i><?php echo e(__('dashboard.clock_out')); ?></button>
                </form>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div class="float-right  d-flex text-center" style="margin-left:auto">
                <p class="mt-2 mr-2">
                    <span class="clock-span"><i class="fas fa-4x fa-clock"></i> <?php echo e(date('g:i A')); ?></span><br>
                </p>
                <button type="button" class="btn  d-flex inputbtnclockin align-items-center btn-success"
                    data-toggle="modal" data-target="#exampleModal"><i
                        class="fas fa-4x fa-sign-out-alt"></i><?php echo e(__('dashboard.clock_in')); ?></button>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if(auth()->user()->getrole->name == 'Employee'): ?>
    <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(route('admin.visitors.index')); ?>">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-primary">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('dashboard.total_visitors')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalVisitor); ?>

                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(route('admin.pre-registers.index')); ?>">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('dashboard.total_pre_registers')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalPrerigister); ?>

                        </div>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <?php else: ?>
    <div class="row">
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(route('admin.employees.index')); ?>">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-danger">
                        <i class="far fa-user"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('dashboard.total_employees')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalEmployees); ?>

                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(route('admin.visitors.index')); ?>">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-primary">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('dashboard.total_visitors')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalVisitor); ?>

                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(route('admin.pre-registers.index')); ?>">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('dashboard.total_pre_registers')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalPrerigister); ?>

                        </div>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-9">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(__('dashboard.visitors')); ?> <span class="badge badge-primary"><?php echo e($totalVisitor); ?></span></h4>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive table-invoice">
                        <table class="table table-striped">
                            <tr>
                                <th><?php echo e(__('dashboard.name')); ?></th>
                                <th><?php echo e(__('dashboard.email')); ?></th>
                                <th><?php echo e(__('dashboard.visitor_id')); ?></th>
                                <th><?php echo e(__('dashboard.employee')); ?></th>
                                <th><?php echo e(__('dashboard.action')); ?></th>
                            </tr>
                            <?php if(!blank($visitors)): ?>
                            <?php $__currentLoopData = $visitors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visitor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            if($loop->index > 5) {
                            break;
                            }
                            ?>
                            <tr>
                                <td><?php echo e(optional($visitor->visitor)->name); ?></td>
                                <td><?php echo e(optional($visitor->visitor)->email); ?></td>
                                <td><?php echo e($visitor->reg_no); ?></td>
                                <td><?php echo e(optional($visitor->employee)->user->name); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.visitors.show', $visitor)); ?>"
                                        class="btn btn-sm btn-icon btn-primary"><i class="far fa-eye"></i></a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="profile-dashboard bg-maroon-light">
                    <a href="<?php echo e(route('admin.profile')); ?>">
                        <img src="<?php echo e(auth()->user()->images); ?>" alt="">
                    </a>
                    <h1><?php echo e(auth()->user()->name); ?></h1>
                    <p>
                        <?php echo e(auth()->user()->getrole->name ?? ''); ?>

                    </p>
                </div>
                <div class="list-group">
                    <li class="list-group-item list-group-item-action"><i class="fa fa-user"></i>
                        <?php echo e(auth()->user()->username); ?></li>
                    <li class="list-group-item list-group-item-action"><i class="fa fa-envelope"></i>
                        <?php echo e(auth()->user()->email); ?></li>
                    <li class="list-group-item list-group-item-action"><i class="fa fa-phone"></i>
                        <?php echo e(auth()->user()->phone); ?></li>
                    <li class="list-group-item list-group-item-action"><i class="fa fa-map"></i>
                        <?php echo e(auth()->user()->address); ?></li>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('dashboard.clock_in')); ?> - <span
                        class="clock-span"><i class="fas fa-4x fa-clock"></i> <?php echo e(date('g:i A')); ?></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('admin.attendance.clockin')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label><?php echo e(__('dashboard.working_from')); ?></label>
                        <input type="text" name="title" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('title')); ?>" placeholder="e.g. Office, Home, etc.">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal"><?php echo e(__('dashboard.close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('dashboard.clock_in')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/kawsaruddin/Workspace/8.0/vps/resources/views/admin/dashboard/index.blade.php ENDPATH**/ ?>