<!DOCTYPE>
<html>

<?php echo $__env->make('frontend.layouts.partials.head._head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body class="pm-home pm-home-css-custom">
    

    <header id="pm-header" class="pm-main-header  header-type-one">
        <div class="container">
            <div class="pm-main-header-content clearfix">
                <div class="pm-logo float-left">
                    <?php if(setting('site_logo')): ?>
                    <a href="<?php echo e(route('/')); ?>">
                        <img src="<?php echo e(asset('images/'.setting('site_logo'))); ?>" data-inject-svg="" alt="" style="height: 40px !important;">
                    </a>
                    <?php endif; ?>
                </div>

                <div class="pm-main-menu-item float-right">
                    <div class="pm-header-btn text-center text-capitalize float-right">
                        <?php if(auth()->user()): ?>
                        <a href="<?php echo e(route('admin.dashboard.index')); ?>"><?php echo e(__('frontend.go_to_dashboard')); ?></a>
                        <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>"><?php echo e(__('frontend.login')); ?></a>
                        <?php endif; ?>
                    </div>

                    <nav class="pm-main-navigation float-right clearfix ul-li">
                        <ul id="main-nav" class="navbar-nav text-capitalize clearfix">
                            <li><a href="<?php echo e(route('check-in.pre.registered')); ?>"><?php echo e(__('frontend.have_appoinment')); ?></a></li>
                            <li><a href="<?php echo e(route('check-in.return')); ?>"><?php echo e(__('frontend.been_here_before')); ?></a> </li>
                            <?php if(auth()->user()): ?>
                            <li>
                                <a href="<?php echo e(route('checkout.index')); ?>"><?php echo e(__('frontend.check_out')); ?></a>
                            </li>
                            <?php endif; ?>
                            <li class="dropdown">
                                <a href="" data-toggle="dropdown" class="language nav-link dropdown-toggle nav-link-lg nav-link-user">
                                    <?php if(!blank($language)): ?>
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Session()->has('applocale') AND Session()->get('applocale') AND setting('locale')): ?>
                                    <?php if(Session()->get('applocale') == $lang->code): ?>
                                    <div class="d-sm-none d-lg-inline-block "><span class="flag-icon"><?php echo e($lang->flag_icon == null ? '🇬🇧' : $lang->flag_icon); ?></span><?php echo e($lang->name); ?></div>
                                    <?php endif; ?>
                                    <?php else: ?>
                                    <?php if(setting('locale') == $lang->code): ?>
                                    <div class="d-sm-none d-lg-inline-block "><span class="flag-icon"><?php echo e($lang->flag_icon == null ? '🇬🇧' : $lang->flag_icon); ?></span><?php echo e($lang->name); ?></div>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right" style="border-bottom:none !important; width:100px !important">
                                    <?php if(!blank($language)): ?>
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('admin.lang.index',$lang->code)); ?>" class="language dropdown-item has-icon text-center" style="min-width:100px !important">
                                        <span class="flag-icon flag-icon-aw"><?php echo e($lang->flag_icon == null ? '🇬🇧' : $lang->flag_icon); ?> </span><?php echo e($lang->name); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </li>


                        </ul>
                    </nav>
                </div>
            </div>
            <!-- /desktop menu -->
            <div class="pm-mobile_menu relative-position">
                <div class="pm-mobile_menu_button pm-open_mobile_menu">
                    <i class="fas fa-bars"></i>
                </div>
                <div class="pm-mobile_menu_wrap">
                    <div class="mobile_menu_overlay pm-open_mobile_menu"></div>
                    <div class="pm-mobile_menu_content">
                        <div class="pm-mobile_menu_close pm-open_mobile_menu">
                            <i class="far fa-times-circle"></i>
                        </div>
                        <div class="m-brand-logo text-center">
                            <a href="<?php echo e(route('/')); ?>"><img src="<?php echo e(asset('images/'.setting('site_logo'))); ?>" alt="logo"></a>
                        </div>
                        <nav class="pm-mobile-main-navigation  clearfix ul-li">
                            <ul id="m-main-nav" class="navbar-nav text-capitalize clearfix">
                                <li><a href="<?php echo e(route('check-in.pre.registered')); ?>"><?php echo e(__('frontend.have_appoinment')); ?></a></li>
                                <li><a href="<?php echo e(route('check-in.return')); ?>"><?php echo e(__('frontend.been_here_before')); ?></a> </li>
                                <?php if(auth()->user()): ?>
                                <li> <a href="<?php echo e(route('checkout.index')); ?>"><?php echo e(__('frontend.check_out')); ?></a></li>
                                <li><a href="<?php echo e(route('admin.dashboard.index')); ?>"><?php echo e(__('frontend.go_to_dashboard')); ?></a></li>
                                <?php else: ?>
                                <li>
                                    <a href="<?php echo e(route('login')); ?>"><?php echo e(__('frontend.login')); ?></a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                </div>
                <!-- /Mobile-Menu -->
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <div class="main" data-mobile-height="">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <!-- Main Content -->

    <?php echo $__env->yieldContent('extras'); ?>

    <?php echo $__env->yieldPushContent('modals'); ?>

    <?php echo $__env->make('frontend.layouts.partials.script._scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('js'); ?>

</body>

</html>
<?php /**PATH /Users/kawsaruddin/Workspace/8.0/vps/resources/views/frontend/layouts/frontend.blade.php ENDPATH**/ ?>